package io.k8s.api.authorization.v1


/** NonResourceRule holds information that describes a rule for the non-resource */
final case class NonResourceRule(
  nonResourceURLs : Option[Seq[String]] = None,
  verbs : Seq[String]
) {
  def withNonResourceURLs(value: Seq[String]) : NonResourceRule = copy(nonResourceURLs = Some(value))
  def addNonResourceURLs(newValues: String*) : NonResourceRule = copy(nonResourceURLs = Some(nonResourceURLs.fold(newValues)(_ ++ newValues)))

  def withVerbs(value: Seq[String]) : NonResourceRule = copy(verbs = value)
  def addVerbs(newValues: String*) : NonResourceRule = copy(verbs = verbs ++ newValues)

}

