package io.k8s.api.authorization.v1


/** NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface */
final case class NonResourceAttributes(
  path : Option[String] = None,
  verb : Option[String] = None
) {
  def withPath(value: String) : NonResourceAttributes = copy(path = Some(value))
  def withVerb(value: String) : NonResourceAttributes = copy(verb = Some(value))
}

