package io.k8s.api.authorization.v1

import dev.hnaderi.k8s._

/** LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking. */
final case class LocalSubjectAccessReview(
  status : Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] = None,
  spec : io.k8s.api.authorization.v1.SubjectAccessReviewSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authorization.k8s.io", "LocalSubjectAccessReview", "v1")

  def withStatus(value: io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : LocalSubjectAccessReview = copy(status = Some(value))
  def withSpec(value: io.k8s.api.authorization.v1.SubjectAccessReviewSpec) : LocalSubjectAccessReview = copy(spec = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : LocalSubjectAccessReview = copy(metadata = Some(value))
}

