package io.k8s.api.authentication.v1


/** UserInfo holds the information about the user needed to implement the user.Info interface. */
final case class UserInfo(
  extra : Option[Map[String, Seq[String]]] = None,
  groups : Option[Seq[String]] = None,
  uid : Option[String] = None,
  username : Option[String] = None
) {
  def withExtra(value: Map[String, Seq[String]]) : UserInfo = copy(extra = Some(value))
  def addExtra(newValues: (String, Seq[String])*) : UserInfo = copy(extra = Some(extra.fold(newValues.toMap)(_ ++ newValues)))

  def withGroups(value: Seq[String]) : UserInfo = copy(groups = Some(value))
  def addGroups(newValues: String*) : UserInfo = copy(groups = Some(groups.fold(newValues)(_ ++ newValues)))

  def withUid(value: String) : UserInfo = copy(uid = Some(value))
  def withUsername(value: String) : UserInfo = copy(username = Some(value))
}

