package io.k8s.api.authentication.v1

import dev.hnaderi.k8s._

/** TokenRequest requests a token for a given service account. */
final case class TokenRequest(
  status : Option[io.k8s.api.authentication.v1.TokenRequestStatus] = None,
  spec : io.k8s.api.authentication.v1.TokenRequestSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authentication.k8s.io", "TokenRequest", "v1")

  def withStatus(value: io.k8s.api.authentication.v1.TokenRequestStatus) : TokenRequest = copy(status = Some(value))
  def withSpec(value: io.k8s.api.authentication.v1.TokenRequestSpec) : TokenRequest = copy(spec = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : TokenRequest = copy(metadata = Some(value))
}

