package io.k8s.api.apps.v1


/** A StatefulSetSpec is the specification of a StatefulSet. */
final case class StatefulSetSpec(
  minReadySeconds : Option[Int] = None,
  serviceName : String,
  replicas : Option[Int] = None,
  revisionHistoryLimit : Option[Int] = None,
  podManagementPolicy : Option[String] = None,
  volumeClaimTemplates : Option[Seq[io.k8s.api.core.v1.PersistentVolumeClaim]] = None,
  persistentVolumeClaimRetentionPolicy : Option[io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy] = None,
  template : io.k8s.api.core.v1.PodTemplateSpec,
  selector : io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  updateStrategy : Option[io.k8s.api.apps.v1.StatefulSetUpdateStrategy] = None
) {
  def withMinReadySeconds(value: Int) : StatefulSetSpec = copy(minReadySeconds = Some(value))
  def withServiceName(value: String) : StatefulSetSpec = copy(serviceName = value)
  def withReplicas(value: Int) : StatefulSetSpec = copy(replicas = Some(value))
  def withRevisionHistoryLimit(value: Int) : StatefulSetSpec = copy(revisionHistoryLimit = Some(value))
  def withPodManagementPolicy(value: String) : StatefulSetSpec = copy(podManagementPolicy = Some(value))
  def withVolumeClaimTemplates(value: Seq[io.k8s.api.core.v1.PersistentVolumeClaim]) : StatefulSetSpec = copy(volumeClaimTemplates = Some(value))
  def addVolumeClaimTemplates(newValues: io.k8s.api.core.v1.PersistentVolumeClaim*) : StatefulSetSpec = copy(volumeClaimTemplates = Some(volumeClaimTemplates.fold(newValues)(_ ++ newValues)))

  def withPersistentVolumeClaimRetentionPolicy(value: io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy) : StatefulSetSpec = copy(persistentVolumeClaimRetentionPolicy = Some(value))
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : StatefulSetSpec = copy(template = value)
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : StatefulSetSpec = copy(selector = value)
  def withUpdateStrategy(value: io.k8s.api.apps.v1.StatefulSetUpdateStrategy) : StatefulSetSpec = copy(updateStrategy = Some(value))
}

