package io.k8s.api.apps.v1


/** StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates. */
final case class StatefulSetPersistentVolumeClaimRetentionPolicy(
  whenDeleted : Option[String] = None,
  whenScaled : Option[String] = None
) {
  def withWhenDeleted(value: String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenDeleted = Some(value))
  def withWhenScaled(value: String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenScaled = Some(value))
}

