package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** StatefulSetList is a collection of StatefulSets. */
final case class StatefulSetList(
  items : Seq[io.k8s.api.apps.v1.StatefulSet],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "StatefulSetList", "v1")

  def withItems(value: Seq[io.k8s.api.apps.v1.StatefulSet]) : StatefulSetList = copy(items = value)
  def addItems(newValues: io.k8s.api.apps.v1.StatefulSet*) : StatefulSetList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StatefulSetList = copy(metadata = Some(value))
}

