package io.k8s.api.apps.v1


/** StatefulSetCondition describes the state of a statefulset at a certain point. */
final case class StatefulSetCondition(
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withReason(value: String) : StatefulSetCondition = copy(reason = Some(value))
  def withStatus(value: String) : StatefulSetCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : StatefulSetCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : StatefulSetCondition = copy(message = Some(value))
  def withType(value: String) : StatefulSetCondition = copy(`type` = value)
}

