package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** ReplicaSet ensures that a specified number of pod replicas are running at any given time. */
final case class ReplicaSet(
  status : Option[io.k8s.api.apps.v1.ReplicaSetStatus] = None,
  spec : Option[io.k8s.api.apps.v1.ReplicaSetSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "ReplicaSet", "v1")

  def withStatus(value: io.k8s.api.apps.v1.ReplicaSetStatus) : ReplicaSet = copy(status = Some(value))
  def withSpec(value: io.k8s.api.apps.v1.ReplicaSetSpec) : ReplicaSet = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ReplicaSet = copy(metadata = Some(value))
}

