package io.k8s.api.apps.v1


/** DeploymentSpec is the specification of the desired behavior of the Deployment. */
final case class DeploymentSpec(
  minReadySeconds : Option[Int] = None,
  progressDeadlineSeconds : Option[Int] = None,
  replicas : Option[Int] = None,
  revisionHistoryLimit : Option[Int] = None,
  paused : Option[Boolean] = None,
  strategy : Option[io.k8s.api.apps.v1.DeploymentStrategy] = None,
  template : io.k8s.api.core.v1.PodTemplateSpec,
  selector : io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
) {
  def withMinReadySeconds(value: Int) : DeploymentSpec = copy(minReadySeconds = Some(value))
  def withProgressDeadlineSeconds(value: Int) : DeploymentSpec = copy(progressDeadlineSeconds = Some(value))
  def withReplicas(value: Int) : DeploymentSpec = copy(replicas = Some(value))
  def withRevisionHistoryLimit(value: Int) : DeploymentSpec = copy(revisionHistoryLimit = Some(value))
  def withPaused(value: Boolean) : DeploymentSpec = copy(paused = Some(value))
  def withStrategy(value: io.k8s.api.apps.v1.DeploymentStrategy) : DeploymentSpec = copy(strategy = Some(value))
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : DeploymentSpec = copy(template = value)
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : DeploymentSpec = copy(selector = value)
}

