package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** DeploymentList is a list of Deployments. */
final case class DeploymentList(
  items : Seq[io.k8s.api.apps.v1.Deployment],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "DeploymentList", "v1")

  def withItems(value: Seq[io.k8s.api.apps.v1.Deployment]) : DeploymentList = copy(items = value)
  def addItems(newValues: io.k8s.api.apps.v1.Deployment*) : DeploymentList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : DeploymentList = copy(metadata = Some(value))
}

