package io.k8s.api.apps.v1


/** DeploymentCondition describes the state of a deployment at a certain point. */
final case class DeploymentCondition(
  lastUpdateTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withLastUpdateTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : DeploymentCondition = copy(lastUpdateTime = Some(value))
  def withReason(value: String) : DeploymentCondition = copy(reason = Some(value))
  def withStatus(value: String) : DeploymentCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : DeploymentCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : DeploymentCondition = copy(message = Some(value))
  def withType(value: String) : DeploymentCondition = copy(`type` = value)
}

