package io.k8s.api.apps.v1


/** DaemonSetStatus represents the current status of a daemon set. */
final case class DaemonSetStatus(
  conditions : Option[Seq[io.k8s.api.apps.v1.DaemonSetCondition]] = None,
  updatedNumberScheduled : Option[Int] = None,
  numberMisscheduled : Int,
  collisionCount : Option[Int] = None,
  currentNumberScheduled : Int,
  numberUnavailable : Option[Int] = None,
  observedGeneration : Option[Int] = None,
  desiredNumberScheduled : Int,
  numberReady : Int,
  numberAvailable : Option[Int] = None
) {
  def withConditions(value: Seq[io.k8s.api.apps.v1.DaemonSetCondition]) : DaemonSetStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.apps.v1.DaemonSetCondition*) : DaemonSetStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withUpdatedNumberScheduled(value: Int) : DaemonSetStatus = copy(updatedNumberScheduled = Some(value))
  def withNumberMisscheduled(value: Int) : DaemonSetStatus = copy(numberMisscheduled = value)
  def withCollisionCount(value: Int) : DaemonSetStatus = copy(collisionCount = Some(value))
  def withCurrentNumberScheduled(value: Int) : DaemonSetStatus = copy(currentNumberScheduled = value)
  def withNumberUnavailable(value: Int) : DaemonSetStatus = copy(numberUnavailable = Some(value))
  def withObservedGeneration(value: Int) : DaemonSetStatus = copy(observedGeneration = Some(value))
  def withDesiredNumberScheduled(value: Int) : DaemonSetStatus = copy(desiredNumberScheduled = value)
  def withNumberReady(value: Int) : DaemonSetStatus = copy(numberReady = value)
  def withNumberAvailable(value: Int) : DaemonSetStatus = copy(numberAvailable = Some(value))
}

