package io.k8s.api.apps.v1


/** DaemonSetSpec is the specification of a daemon set. */
final case class DaemonSetSpec(
  minReadySeconds : Option[Int] = None,
  revisionHistoryLimit : Option[Int] = None,
  template : io.k8s.api.core.v1.PodTemplateSpec,
  selector : io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  updateStrategy : Option[io.k8s.api.apps.v1.DaemonSetUpdateStrategy] = None
) {
  def withMinReadySeconds(value: Int) : DaemonSetSpec = copy(minReadySeconds = Some(value))
  def withRevisionHistoryLimit(value: Int) : DaemonSetSpec = copy(revisionHistoryLimit = Some(value))
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : DaemonSetSpec = copy(template = value)
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : DaemonSetSpec = copy(selector = value)
  def withUpdateStrategy(value: io.k8s.api.apps.v1.DaemonSetUpdateStrategy) : DaemonSetSpec = copy(updateStrategy = Some(value))
}

