package io.k8s.api.apps.v1


/** DaemonSetCondition describes the state of a DaemonSet at a certain point. */
final case class DaemonSetCondition(
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withReason(value: String) : DaemonSetCondition = copy(reason = Some(value))
  def withStatus(value: String) : DaemonSetCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : DaemonSetCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : DaemonSetCondition = copy(message = Some(value))
  def withType(value: String) : DaemonSetCondition = copy(`type` = value)
}

