package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** ControllerRevisionList is a resource containing a list of ControllerRevision objects. */
final case class ControllerRevisionList(
  items : Seq[io.k8s.api.apps.v1.ControllerRevision],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "ControllerRevisionList", "v1")

  def withItems(value: Seq[io.k8s.api.apps.v1.ControllerRevision]) : ControllerRevisionList = copy(items = value)
  def addItems(newValues: io.k8s.api.apps.v1.ControllerRevision*) : ControllerRevisionList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ControllerRevisionList = copy(metadata = Some(value))
}

