package io.k8s.api.apps.v1

import dev.hnaderi.k8s._

/** ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers. */
final case class ControllerRevision(
  data : Option[io.k8s.apimachinery.pkg.runtime.RawExtension] = None,
  revision : Int,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "ControllerRevision", "v1")

  def withData(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : ControllerRevision = copy(data = Some(value))
  def withRevision(value: Int) : ControllerRevision = copy(revision = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ControllerRevision = copy(metadata = Some(value))
}

