package io.k8s.api.apiserverinternal.v1alpha1


/** API server instances report the versions they can decode and the version they encode objects to when persisting objects in the backend. */
final case class StorageVersionStatus(
  commonEncodingVersion : Option[String] = None,
  conditions : Option[Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition]] = None,
  storageVersions : Option[Seq[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion]] = None
) {
  def withCommonEncodingVersion(value: String) : StorageVersionStatus = copy(commonEncodingVersion = Some(value))
  def withConditions(value: Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition]) : StorageVersionStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition*) : StorageVersionStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withStorageVersions(value: Seq[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion]) : StorageVersionStatus = copy(storageVersions = Some(value))
  def addStorageVersions(newValues: io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion*) : StorageVersionStatus = copy(storageVersions = Some(storageVersions.fold(newValues)(_ ++ newValues)))

}

