package io.k8s.api.apiserverinternal.v1alpha1

import dev.hnaderi.k8s._

/** A list of StorageVersions. */
final case class StorageVersionList(
  items : Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("internal.apiserver.k8s.io", "StorageVersionList", "v1alpha1")

  def withItems(value: Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion]) : StorageVersionList = copy(items = value)
  def addItems(newValues: io.k8s.api.apiserverinternal.v1alpha1.StorageVersion*) : StorageVersionList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageVersionList = copy(metadata = Some(value))
}

