package io.k8s.api.admissionregistration.v1


/** WebhookClientConfig contains the information to make a TLS connection with the webhook */
final case class WebhookClientConfig(
  caBundle : Option[String] = None,
  service : Option[io.k8s.api.admissionregistration.v1.ServiceReference] = None,
  url : Option[String] = None
) {
  def withCaBundle(value: String) : WebhookClientConfig = copy(caBundle = Some(value))
  def withService(value: io.k8s.api.admissionregistration.v1.ServiceReference) : WebhookClientConfig = copy(service = Some(value))
  def withUrl(value: String) : WebhookClientConfig = copy(url = Some(value))
}

