package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._

/** ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration. */
final case class ValidatingWebhookConfigurationList(
  items : Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingWebhookConfigurationList", "v1")

  def withItems(value: Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration]) : ValidatingWebhookConfigurationList = copy(items = value)
  def addItems(newValues: io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration*) : ValidatingWebhookConfigurationList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ValidatingWebhookConfigurationList = copy(metadata = Some(value))
}

