package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._

/** ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it. */
final case class ValidatingWebhookConfiguration(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  webhooks : Option[Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingWebhookConfiguration", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingWebhookConfiguration = copy(metadata = Some(value))
  def withWebhooks(value: Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]) : ValidatingWebhookConfiguration = copy(webhooks = Some(value))
  def addWebhooks(newValues: io.k8s.api.admissionregistration.v1.ValidatingWebhook*) : ValidatingWebhookConfiguration = copy(webhooks = Some(webhooks.fold(newValues)(_ ++ newValues)))

}

