package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** AzureFile represents an Azure File Service mount on the host and bind mount to the pod. */
final case class AzureFileVolumeSource(
  secretName : String,
  shareName : String,
  readOnly : Option[Boolean] = None
) {

  /** Returns a new data with secretName set to new value */
  def withSecretName(value: String) : AzureFileVolumeSource = copy(secretName = value)
  /** transforms secretName to result of function */
  def mapSecretName(f: String => String) : AzureFileVolumeSource = copy(secretName = f(secretName))

  /** Returns a new data with shareName set to new value */
  def withShareName(value: String) : AzureFileVolumeSource = copy(shareName = value)
  /** transforms shareName to result of function */
  def mapShareName(f: String => String) : AzureFileVolumeSource = copy(shareName = f(shareName))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : AzureFileVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : AzureFileVolumeSource = copy(readOnly = readOnly.map(f))
}

object AzureFileVolumeSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.AzureFileVolumeSource] = new Encoder[io.k8s.api.core.v1.AzureFileVolumeSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.AzureFileVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("secretName", o.secretName)
            .write("shareName", o.shareName)
            .write("readOnly", o.readOnly)
            .build
        }
    }

    implicit val decoder: Decoder[AzureFileVolumeSource] = new Decoder[AzureFileVolumeSource] {
      def apply[T : Reader](t: T): Either[String, AzureFileVolumeSource] = for {
          obj <- ObjectReader(t)
          secretName <- obj.read[String]("secretName")
          shareName <- obj.read[String]("shareName")
          readOnly <- obj.readOpt[Boolean]("readOnly")
      } yield AzureFileVolumeSource (
          secretName = secretName,
          shareName = shareName,
          readOnly = readOnly
        )
    }
}

