package io.k8s.api.coordination.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Lease defines a lease concept. */
final case class Lease(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.coordination.v1.LeaseSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("coordination.k8s.io", "Lease", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Lease = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Lease = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.coordination.v1.LeaseSpec) : Lease = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.coordination.v1.LeaseSpec => io.k8s.api.coordination.v1.LeaseSpec) : Lease = copy(spec = spec.map(f))

  override def foldTo[T : Builder] : T = Lease.encoder.apply(this)
}

object Lease {

    implicit val encoder : Encoder[io.k8s.api.coordination.v1.Lease] = new Encoder[io.k8s.api.coordination.v1.Lease] {
        def apply[T : Builder](o: io.k8s.api.coordination.v1.Lease) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("spec", o.spec)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[Lease] = new Decoder[Lease] {
      def apply[T : Reader](t: T): Either[String, Lease] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          spec <- obj.readOpt[io.k8s.api.coordination.v1.LeaseSpec]("spec")
      } yield Lease (
          metadata = metadata,
          spec = spec
        )
    }
}

