package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.utils._

/** ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}. */
final case class ListMeta(
  continue : Option[String] = None,
  remainingItemCount : Option[Int] = None,
  resourceVersion : Option[String] = None,
  selfLink : Option[String] = None
) {

  /** Returns a new data with continue set to new value */
  def withContinue(value: String) : ListMeta = copy(continue = Some(value))
  /** if continue has a value, transforms to the result of function*/
  def mapContinue(f: String => String) : ListMeta = copy(continue = continue.map(f))

  /** Returns a new data with remainingItemCount set to new value */
  def withRemainingItemCount(value: Int) : ListMeta = copy(remainingItemCount = Some(value))
  /** if remainingItemCount has a value, transforms to the result of function*/
  def mapRemainingItemCount(f: Int => Int) : ListMeta = copy(remainingItemCount = remainingItemCount.map(f))

  /** Returns a new data with resourceVersion set to new value */
  def withResourceVersion(value: String) : ListMeta = copy(resourceVersion = Some(value))
  /** if resourceVersion has a value, transforms to the result of function*/
  def mapResourceVersion(f: String => String) : ListMeta = copy(resourceVersion = resourceVersion.map(f))

  /** Returns a new data with selfLink set to new value */
  def withSelfLink(value: String) : ListMeta = copy(selfLink = Some(value))
  /** if selfLink has a value, transforms to the result of function*/
  def mapSelfLink(f: String => String) : ListMeta = copy(selfLink = selfLink.map(f))
}

object ListMeta {

    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("continue", o.continue)
            .write("remainingItemCount", o.remainingItemCount)
            .write("resourceVersion", o.resourceVersion)
            .write("selfLink", o.selfLink)
            .build
        }
    }

    implicit val decoder: Decoder[ListMeta] = new Decoder[ListMeta] {
      def apply[T : Reader](t: T): Either[String, ListMeta] = for {
          obj <- ObjectReader(t)
          continue <- obj.readOpt[String]("continue")
          remainingItemCount <- obj.readOpt[Int]("remainingItemCount")
          resourceVersion <- obj.readOpt[String]("resourceVersion")
          selfLink <- obj.readOpt[String]("selfLink")
      } yield ListMeta (
          continue = continue,
          remainingItemCount = remainingItemCount,
          resourceVersion = resourceVersion,
          selfLink = selfLink
        )
    }
}

