package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements. */
final case class ScopeSelector(
  matchExpressions : Option[Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]] = None
) {

  /** Returns a new data with matchExpressions set to new value */
  def withMatchExpressions(value: Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]) : ScopeSelector = copy(matchExpressions = Some(value))
  /** Appends new values to matchExpressions */
  def addMatchExpressions(newValues: io.k8s.api.core.v1.ScopedResourceSelectorRequirement*) : ScopeSelector = copy(matchExpressions = Some(matchExpressions.fold(newValues)(_ ++ newValues)))
  /** if matchExpressions has a value, transforms to the result of function*/
  def mapMatchExpressions(f: Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement] => Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]) : ScopeSelector = copy(matchExpressions = matchExpressions.map(f))
}

object ScopeSelector {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ScopeSelector] = new Encoder[io.k8s.api.core.v1.ScopeSelector] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ScopeSelector) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("matchExpressions", o.matchExpressions)
            .build
        }
    }

    implicit val decoder: Decoder[ScopeSelector] = new Decoder[ScopeSelector] {
      def apply[T : Reader](t: T): Either[String, ScopeSelector] = for {
          obj <- ObjectReader(t)
          matchExpressions <- obj.readOpt[Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]]("matchExpressions")
      } yield ScopeSelector (
          matchExpressions = matchExpressions
        )
    }
}

