package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** SleepAction describes a "sleep" action. */
final case class SleepAction(
  seconds : Long
) {

  /** Returns a new data with seconds set to new value */
  def withSeconds(value: Long) : SleepAction = copy(seconds = value)
  /** transforms seconds to result of function */
  def mapSeconds(f: Long => Long) : SleepAction = copy(seconds = f(seconds))
}

object SleepAction {

    implicit val encoder : Encoder[io.k8s.api.core.v1.SleepAction] = new Encoder[io.k8s.api.core.v1.SleepAction] {
        def apply[T : Builder](o: io.k8s.api.core.v1.SleepAction) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("seconds", o.seconds)
            .build
        }
    }

    implicit val decoder: Decoder[SleepAction] = new Decoder[SleepAction] {
      def apply[T : Reader](t: T): Either[String, SleepAction] = for {
          obj <- ObjectReader(t)
          seconds <- obj.read[Long]("seconds")
      } yield SleepAction (
          seconds = seconds
        )
    }
}

