package io.k8s.api.flowcontrol.v1beta3

import dev.hnaderi.k8s.utils._

/** FlowSchemaStatus represents the current state of a FlowSchema. */
final case class FlowSchemaStatus(
  conditions : Option[Seq[io.k8s.api.flowcontrol.v1beta3.FlowSchemaCondition]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.flowcontrol.v1beta3.FlowSchemaCondition]) : FlowSchemaStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.flowcontrol.v1beta3.FlowSchemaCondition*) : FlowSchemaStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.flowcontrol.v1beta3.FlowSchemaCondition] => Seq[io.k8s.api.flowcontrol.v1beta3.FlowSchemaCondition]) : FlowSchemaStatus = copy(conditions = conditions.map(f))
}

object FlowSchemaStatus {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta3.FlowSchemaStatus] = new Encoder[io.k8s.api.flowcontrol.v1beta3.FlowSchemaStatus] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta3.FlowSchemaStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .build
        }
    }

    implicit val decoder: Decoder[FlowSchemaStatus] = new Decoder[FlowSchemaStatus] {
      def apply[T : Reader](t: T): Either[String, FlowSchemaStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.api.flowcontrol.v1beta3.FlowSchemaCondition]]("conditions")
      } yield FlowSchemaStatus (
          conditions = conditions
        )
    }
}

