package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._

/** Status is a return value for calls that don't return other objects. */
final case class Status(
  reason : Option[String] = None,
  code : Option[Int] = None,
  status : Option[String] = None,
  details : Option[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None,
  message : Option[String] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "Status", "v1")


  /** Returns a new data with reason set to new value */
  def withReason(value: String) : Status = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : Status = copy(reason = reason.map(f))

  /** Returns a new data with code set to new value */
  def withCode(value: Int) : Status = copy(code = Some(value))
  /** if code has a value, transforms to the result of function*/
  def mapCode(f: Int => Int) : Status = copy(code = code.map(f))

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : Status = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: String => String) : Status = copy(status = status.map(f))

  /** Returns a new data with details set to new value */
  def withDetails(value: io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails) : Status = copy(details = Some(value))
  /** if details has a value, transforms to the result of function*/
  def mapDetails(f: io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails => io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails) : Status = copy(details = details.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : Status = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : Status = copy(metadata = metadata.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : Status = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : Status = copy(message = message.map(f))
}

