package io.k8s.apimachinery.pkg.apis.meta.v1


/** ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create. */
final case class ObjectMeta(
  name : Option[String] = None,
  ownerReferences : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference]] = None,
  creationTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  generation : Option[Int] = None,
  resourceVersion : Option[String] = None,
  generateName : Option[String] = None,
  deletionGracePeriodSeconds : Option[Int] = None,
  selfLink : Option[String] = None,
  finalizers : Option[Seq[String]] = None,
  annotations : Option[Map[String, String]] = None,
  managedFields : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry]] = None,
  labels : Option[Map[String, String]] = None,
  uid : Option[String] = None,
  namespace : Option[String] = None,
  deletionTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ObjectMeta = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ObjectMeta = copy(name = name.map(f))

  /** Returns a new data with ownerReferences set to new value */
  def withOwnerReferences(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference]) : ObjectMeta = copy(ownerReferences = Some(value))
  /** Appends new values to ownerReferences */
  def addOwnerReferences(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference*) : ObjectMeta = copy(ownerReferences = Some(ownerReferences.fold(newValues)(_ ++ newValues)))
  /** if ownerReferences has a value, transforms to the result of function*/
  def mapOwnerReferences(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference]) : ObjectMeta = copy(ownerReferences = ownerReferences.map(f))

  /** Returns a new data with creationTimestamp set to new value */
  def withCreationTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ObjectMeta = copy(creationTimestamp = Some(value))
  /** if creationTimestamp has a value, transforms to the result of function*/
  def mapCreationTimestamp(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ObjectMeta = copy(creationTimestamp = creationTimestamp.map(f))

  /** Returns a new data with generation set to new value */
  def withGeneration(value: Int) : ObjectMeta = copy(generation = Some(value))
  /** if generation has a value, transforms to the result of function*/
  def mapGeneration(f: Int => Int) : ObjectMeta = copy(generation = generation.map(f))

  /** Returns a new data with resourceVersion set to new value */
  def withResourceVersion(value: String) : ObjectMeta = copy(resourceVersion = Some(value))
  /** if resourceVersion has a value, transforms to the result of function*/
  def mapResourceVersion(f: String => String) : ObjectMeta = copy(resourceVersion = resourceVersion.map(f))

  /** Returns a new data with generateName set to new value */
  def withGenerateName(value: String) : ObjectMeta = copy(generateName = Some(value))
  /** if generateName has a value, transforms to the result of function*/
  def mapGenerateName(f: String => String) : ObjectMeta = copy(generateName = generateName.map(f))

  /** Returns a new data with deletionGracePeriodSeconds set to new value */
  def withDeletionGracePeriodSeconds(value: Int) : ObjectMeta = copy(deletionGracePeriodSeconds = Some(value))
  /** if deletionGracePeriodSeconds has a value, transforms to the result of function*/
  def mapDeletionGracePeriodSeconds(f: Int => Int) : ObjectMeta = copy(deletionGracePeriodSeconds = deletionGracePeriodSeconds.map(f))

  /** Returns a new data with selfLink set to new value */
  def withSelfLink(value: String) : ObjectMeta = copy(selfLink = Some(value))
  /** if selfLink has a value, transforms to the result of function*/
  def mapSelfLink(f: String => String) : ObjectMeta = copy(selfLink = selfLink.map(f))

  /** Returns a new data with finalizers set to new value */
  def withFinalizers(value: Seq[String]) : ObjectMeta = copy(finalizers = Some(value))
  /** Appends new values to finalizers */
  def addFinalizers(newValues: String*) : ObjectMeta = copy(finalizers = Some(finalizers.fold(newValues)(_ ++ newValues)))
  /** if finalizers has a value, transforms to the result of function*/
  def mapFinalizers(f: Seq[String] => Seq[String]) : ObjectMeta = copy(finalizers = finalizers.map(f))

  /** Returns a new data with annotations set to new value */
  def withAnnotations(value: Map[String, String]) : ObjectMeta = copy(annotations = Some(value))
  /** Adds new values to annotations */
  def addAnnotations(newValues: (String, String)*) : ObjectMeta = copy(annotations = Some(annotations.fold(newValues.toMap)(_ ++ newValues)))
  /** if annotations has a value, transforms to the result of function*/
  def mapAnnotations(f: Map[String, String] => Map[String, String]) : ObjectMeta = copy(annotations = annotations.map(f))

  /** Returns a new data with managedFields set to new value */
  def withManagedFields(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry]) : ObjectMeta = copy(managedFields = Some(value))
  /** Appends new values to managedFields */
  def addManagedFields(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry*) : ObjectMeta = copy(managedFields = Some(managedFields.fold(newValues)(_ ++ newValues)))
  /** if managedFields has a value, transforms to the result of function*/
  def mapManagedFields(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry]) : ObjectMeta = copy(managedFields = managedFields.map(f))

  /** Returns a new data with labels set to new value */
  def withLabels(value: Map[String, String]) : ObjectMeta = copy(labels = Some(value))
  /** Adds new values to labels */
  def addLabels(newValues: (String, String)*) : ObjectMeta = copy(labels = Some(labels.fold(newValues.toMap)(_ ++ newValues)))
  /** if labels has a value, transforms to the result of function*/
  def mapLabels(f: Map[String, String] => Map[String, String]) : ObjectMeta = copy(labels = labels.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : ObjectMeta = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : ObjectMeta = copy(uid = uid.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ObjectMeta = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : ObjectMeta = copy(namespace = namespace.map(f))

  /** Returns a new data with deletionTimestamp set to new value */
  def withDeletionTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ObjectMeta = copy(deletionTimestamp = Some(value))
  /** if deletionTimestamp has a value, transforms to the result of function*/
  def mapDeletionTimestamp(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ObjectMeta = copy(deletionTimestamp = deletionTimestamp.map(f))
}

