package io.k8s.api.policy.v1


/** PodDisruptionBudgetSpec is a description of a PodDisruptionBudget. */
final case class PodDisruptionBudgetSpec(
  maxUnavailable : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  minAvailable : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {

  /** Returns a new data with maxUnavailable set to new value */
  def withMaxUnavailable(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(maxUnavailable = Some(value))
  /** if maxUnavailable has a value, transforms to the result of function*/
  def mapMaxUnavailable(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(maxUnavailable = maxUnavailable.map(f))

  /** Returns a new data with minAvailable set to new value */
  def withMinAvailable(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(minAvailable = Some(value))
  /** if minAvailable has a value, transforms to the result of function*/
  def mapMinAvailable(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(minAvailable = minAvailable.map(f))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PodDisruptionBudgetSpec = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PodDisruptionBudgetSpec = copy(selector = selector.map(f))
}

