package io.k8s.api.networking.v1


/** IngressTLS describes the transport layer security associated with an Ingress. */
final case class IngressTLS(
  hosts : Option[Seq[String]] = None,
  secretName : Option[String] = None
) {

  /** Returns a new data with hosts set to new value */
  def withHosts(value: Seq[String]) : IngressTLS = copy(hosts = Some(value))
  /** Appends new values to hosts */
  def addHosts(newValues: String*) : IngressTLS = copy(hosts = Some(hosts.fold(newValues)(_ ++ newValues)))
  /** if hosts has a value, transforms to the result of function*/
  def mapHosts(f: Seq[String] => Seq[String]) : IngressTLS = copy(hosts = hosts.map(f))

  /** Returns a new data with secretName set to new value */
  def withSecretName(value: String) : IngressTLS = copy(secretName = Some(value))
  /** if secretName has a value, transforms to the result of function*/
  def mapSecretName(f: String => String) : IngressTLS = copy(secretName = secretName.map(f))
}

