package io.k8s.api.flowcontrol.v1beta1


/** PriorityLevelConfigurationReference contains information that points to the "request-priority" being used. */
final case class PriorityLevelConfigurationReference(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PriorityLevelConfigurationReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : PriorityLevelConfigurationReference = copy(name = f(name))
}

