package io.k8s.api.core.v1


/** A topology selector requirement is a selector that matches given label. This is an alpha feature and may change in the future. */
final case class TopologySelectorLabelRequirement(
  key : String,
  values : Seq[String]
) {

  /** Returns a new data with key set to new value */
  def withKey(value: String) : TopologySelectorLabelRequirement = copy(key = value)
  /** transforms key to result of function */
  def mapKey(f: String => String) : TopologySelectorLabelRequirement = copy(key = f(key))

  /** Returns a new data with values set to new value */
  def withValues(value: Seq[String]) : TopologySelectorLabelRequirement = copy(values = value)
  /** Appends new values to values */
  def addValues(newValues: String*) : TopologySelectorLabelRequirement = copy(values = values ++ newValues)
  /** transforms values to result of function */
  def mapValues(f: Seq[String] => Seq[String]) : TopologySelectorLabelRequirement = copy(values = f(values))
}

