package io.k8s.api.core.v1


/** SeccompProfile defines a pod/container's seccomp profile settings. Only one profile source may be set. */
final case class SeccompProfile(
  `type` : String,
  localhostProfile : Option[String] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : SeccompProfile = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : SeccompProfile = copy(`type` = f(`type`))

  /** Returns a new data with localhostProfile set to new value */
  def withLocalhostProfile(value: String) : SeccompProfile = copy(localhostProfile = Some(value))
  /** if localhostProfile has a value, transforms to the result of function*/
  def mapLocalhostProfile(f: String => String) : SeccompProfile = copy(localhostProfile = localhostProfile.map(f))
}

