package io.k8s.api.core.v1


/** A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements. */
final case class ScopeSelector(
  matchExpressions : Option[Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]] = None
) {

  /** Returns a new data with matchExpressions set to new value */
  def withMatchExpressions(value: Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]) : ScopeSelector = copy(matchExpressions = Some(value))
  /** Appends new values to matchExpressions */
  def addMatchExpressions(newValues: io.k8s.api.core.v1.ScopedResourceSelectorRequirement*) : ScopeSelector = copy(matchExpressions = Some(matchExpressions.fold(newValues)(_ ++ newValues)))
  /** if matchExpressions has a value, transforms to the result of function*/
  def mapMatchExpressions(f: Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement] => Seq[io.k8s.api.core.v1.ScopedResourceSelectorRequirement]) : ScopeSelector = copy(matchExpressions = matchExpressions.map(f))
}

