package io.k8s.api.core.v1


/** ScaleIOVolumeSource represents a persistent ScaleIO volume */
final case class ScaleIOVolumeSource(
  system : String,
  secretRef : io.k8s.api.core.v1.LocalObjectReference,
  gateway : String,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  storagePool : Option[String] = None,
  protectionDomain : Option[String] = None,
  volumeName : Option[String] = None,
  sslEnabled : Option[Boolean] = None,
  storageMode : Option[String] = None
) {

  /** Returns a new data with system set to new value */
  def withSystem(value: String) : ScaleIOVolumeSource = copy(system = value)
  /** transforms system to result of function */
  def mapSystem(f: String => String) : ScaleIOVolumeSource = copy(system = f(system))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : ScaleIOVolumeSource = copy(secretRef = value)
  /** transforms secretRef to result of function */
  def mapSecretRef(f: io.k8s.api.core.v1.LocalObjectReference => io.k8s.api.core.v1.LocalObjectReference) : ScaleIOVolumeSource = copy(secretRef = f(secretRef))

  /** Returns a new data with gateway set to new value */
  def withGateway(value: String) : ScaleIOVolumeSource = copy(gateway = value)
  /** transforms gateway to result of function */
  def mapGateway(f: String => String) : ScaleIOVolumeSource = copy(gateway = f(gateway))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : ScaleIOVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : ScaleIOVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : ScaleIOVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : ScaleIOVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with storagePool set to new value */
  def withStoragePool(value: String) : ScaleIOVolumeSource = copy(storagePool = Some(value))
  /** if storagePool has a value, transforms to the result of function*/
  def mapStoragePool(f: String => String) : ScaleIOVolumeSource = copy(storagePool = storagePool.map(f))

  /** Returns a new data with protectionDomain set to new value */
  def withProtectionDomain(value: String) : ScaleIOVolumeSource = copy(protectionDomain = Some(value))
  /** if protectionDomain has a value, transforms to the result of function*/
  def mapProtectionDomain(f: String => String) : ScaleIOVolumeSource = copy(protectionDomain = protectionDomain.map(f))

  /** Returns a new data with volumeName set to new value */
  def withVolumeName(value: String) : ScaleIOVolumeSource = copy(volumeName = Some(value))
  /** if volumeName has a value, transforms to the result of function*/
  def mapVolumeName(f: String => String) : ScaleIOVolumeSource = copy(volumeName = volumeName.map(f))

  /** Returns a new data with sslEnabled set to new value */
  def withSslEnabled(value: Boolean) : ScaleIOVolumeSource = copy(sslEnabled = Some(value))
  /** if sslEnabled has a value, transforms to the result of function*/
  def mapSslEnabled(f: Boolean => Boolean) : ScaleIOVolumeSource = copy(sslEnabled = sslEnabled.map(f))

  /** Returns a new data with storageMode set to new value */
  def withStorageMode(value: String) : ScaleIOVolumeSource = copy(storageMode = Some(value))
  /** if storageMode has a value, transforms to the result of function*/
  def mapStorageMode(f: String => String) : ScaleIOVolumeSource = copy(storageMode = storageMode.map(f))
}

