package io.k8s.api.core.v1


/** NamespaceCondition contains details about state of namespace. */
final case class NamespaceCondition(
  status : String,
  `type` : String,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : NamespaceCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : NamespaceCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : NamespaceCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : NamespaceCondition = copy(`type` = f(`type`))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : NamespaceCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : NamespaceCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NamespaceCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : NamespaceCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : NamespaceCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : NamespaceCondition = copy(message = message.map(f))
}

