package io.k8s.api.core.v1


/** Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling. */
final case class NFSVolumeSource(
  path : String,
  server : String,
  readOnly : Option[Boolean] = None
) {

  /** Returns a new data with path set to new value */
  def withPath(value: String) : NFSVolumeSource = copy(path = value)
  /** transforms path to result of function */
  def mapPath(f: String => String) : NFSVolumeSource = copy(path = f(path))

  /** Returns a new data with server set to new value */
  def withServer(value: String) : NFSVolumeSource = copy(server = value)
  /** transforms server to result of function */
  def mapServer(f: String => String) : NFSVolumeSource = copy(server = f(server))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : NFSVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : NFSVolumeSource = copy(readOnly = readOnly.map(f))
}

