package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** LimitRange sets resource usage limits for each kind of resource in a Namespace. */
final case class LimitRange(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.core.v1.LimitRangeSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "LimitRange", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : LimitRange = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : LimitRange = copy(metadata = metadata.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.LimitRangeSpec) : LimitRange = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.LimitRangeSpec => io.k8s.api.core.v1.LimitRangeSpec) : LimitRange = copy(spec = spec.map(f))
}

