package io.k8s.api.core.v1


/** Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container. */
final case class GitRepoVolumeSource(
  repository : String,
  directory : Option[String] = None,
  revision : Option[String] = None
) {

  /** Returns a new data with repository set to new value */
  def withRepository(value: String) : GitRepoVolumeSource = copy(repository = value)
  /** transforms repository to result of function */
  def mapRepository(f: String => String) : GitRepoVolumeSource = copy(repository = f(repository))

  /** Returns a new data with directory set to new value */
  def withDirectory(value: String) : GitRepoVolumeSource = copy(directory = Some(value))
  /** if directory has a value, transforms to the result of function*/
  def mapDirectory(f: String => String) : GitRepoVolumeSource = copy(directory = directory.map(f))

  /** Returns a new data with revision set to new value */
  def withRevision(value: String) : GitRepoVolumeSource = copy(revision = Some(value))
  /** if revision has a value, transforms to the result of function*/
  def mapRevision(f: String => String) : GitRepoVolumeSource = copy(revision = revision.map(f))
}

