package io.k8s.api.core.v1


/** EnvVar represents an environment variable present in a Container. */
final case class EnvVar(
  name : String,
  value : Option[String] = None,
  valueFrom : Option[io.k8s.api.core.v1.EnvVarSource] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : EnvVar = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : EnvVar = copy(name = f(name))

  /** Returns a new data with value set to new value */
  def withValue(value: String) : EnvVar = copy(value = Some(value))
  /** if value has a value, transforms to the result of function*/
  def mapValue(f: String => String) : EnvVar = copy(value = value.map(f))

  /** Returns a new data with valueFrom set to new value */
  def withValueFrom(value: io.k8s.api.core.v1.EnvVarSource) : EnvVar = copy(valueFrom = Some(value))
  /** if valueFrom has a value, transforms to the result of function*/
  def mapValueFrom(f: io.k8s.api.core.v1.EnvVarSource => io.k8s.api.core.v1.EnvVarSource) : EnvVar = copy(valueFrom = valueFrom.map(f))
}

