package io.k8s.api.core.v1


/** ContainerStateTerminated is a terminated state of a container. */
final case class ContainerStateTerminated(
  exitCode : Int,
  reason : Option[String] = None,
  startedAt : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  finishedAt : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  containerID : Option[String] = None,
  signal : Option[Int] = None
) {

  /** Returns a new data with exitCode set to new value */
  def withExitCode(value: Int) : ContainerStateTerminated = copy(exitCode = value)
  /** transforms exitCode to result of function */
  def mapExitCode(f: Int => Int) : ContainerStateTerminated = copy(exitCode = f(exitCode))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : ContainerStateTerminated = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : ContainerStateTerminated = copy(reason = reason.map(f))

  /** Returns a new data with startedAt set to new value */
  def withStartedAt(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateTerminated = copy(startedAt = Some(value))
  /** if startedAt has a value, transforms to the result of function*/
  def mapStartedAt(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateTerminated = copy(startedAt = startedAt.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ContainerStateTerminated = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ContainerStateTerminated = copy(message = message.map(f))

  /** Returns a new data with finishedAt set to new value */
  def withFinishedAt(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateTerminated = copy(finishedAt = Some(value))
  /** if finishedAt has a value, transforms to the result of function*/
  def mapFinishedAt(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ContainerStateTerminated = copy(finishedAt = finishedAt.map(f))

  /** Returns a new data with containerID set to new value */
  def withContainerID(value: String) : ContainerStateTerminated = copy(containerID = Some(value))
  /** if containerID has a value, transforms to the result of function*/
  def mapContainerID(f: String => String) : ContainerStateTerminated = copy(containerID = containerID.map(f))

  /** Returns a new data with signal set to new value */
  def withSignal(value: Int) : ContainerStateTerminated = copy(signal = Some(value))
  /** if signal has a value, transforms to the result of function*/
  def mapSignal(f: Int => Int) : ContainerStateTerminated = copy(signal = signal.map(f))
}

