package io.k8s.api.core.v1


/** Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling. */
final case class CinderVolumeSource(
  volumeID : String,
  fsType : Option[String] = None,
  readOnly : Option[Boolean] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None
) {

  /** Returns a new data with volumeID set to new value */
  def withVolumeID(value: String) : CinderVolumeSource = copy(volumeID = value)
  /** transforms volumeID to result of function */
  def mapVolumeID(f: String => String) : CinderVolumeSource = copy(volumeID = f(volumeID))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : CinderVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : CinderVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : CinderVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : CinderVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : CinderVolumeSource = copy(secretRef = Some(value))
  /** if secretRef has a value, transforms to the result of function*/
  def mapSecretRef(f: io.k8s.api.core.v1.LocalObjectReference => io.k8s.api.core.v1.LocalObjectReference) : CinderVolumeSource = copy(secretRef = secretRef.map(f))
}

