package io.k8s.api.certificates.v1


/** CertificateSigningRequestSpec contains the certificate request. */
final case class CertificateSigningRequestSpec(
  request : String,
  signerName : String,
  usages : Option[Seq[String]] = None,
  username : Option[String] = None,
  expirationSeconds : Option[Int] = None,
  groups : Option[Seq[String]] = None,
  uid : Option[String] = None,
  extra : Option[Map[String, Seq[String]]] = None
) {

  /** Returns a new data with request set to new value */
  def withRequest(value: String) : CertificateSigningRequestSpec = copy(request = value)
  /** transforms request to result of function */
  def mapRequest(f: String => String) : CertificateSigningRequestSpec = copy(request = f(request))

  /** Returns a new data with signerName set to new value */
  def withSignerName(value: String) : CertificateSigningRequestSpec = copy(signerName = value)
  /** transforms signerName to result of function */
  def mapSignerName(f: String => String) : CertificateSigningRequestSpec = copy(signerName = f(signerName))

  /** Returns a new data with usages set to new value */
  def withUsages(value: Seq[String]) : CertificateSigningRequestSpec = copy(usages = Some(value))
  /** Appends new values to usages */
  def addUsages(newValues: String*) : CertificateSigningRequestSpec = copy(usages = Some(usages.fold(newValues)(_ ++ newValues)))
  /** if usages has a value, transforms to the result of function*/
  def mapUsages(f: Seq[String] => Seq[String]) : CertificateSigningRequestSpec = copy(usages = usages.map(f))

  /** Returns a new data with username set to new value */
  def withUsername(value: String) : CertificateSigningRequestSpec = copy(username = Some(value))
  /** if username has a value, transforms to the result of function*/
  def mapUsername(f: String => String) : CertificateSigningRequestSpec = copy(username = username.map(f))

  /** Returns a new data with expirationSeconds set to new value */
  def withExpirationSeconds(value: Int) : CertificateSigningRequestSpec = copy(expirationSeconds = Some(value))
  /** if expirationSeconds has a value, transforms to the result of function*/
  def mapExpirationSeconds(f: Int => Int) : CertificateSigningRequestSpec = copy(expirationSeconds = expirationSeconds.map(f))

  /** Returns a new data with groups set to new value */
  def withGroups(value: Seq[String]) : CertificateSigningRequestSpec = copy(groups = Some(value))
  /** Appends new values to groups */
  def addGroups(newValues: String*) : CertificateSigningRequestSpec = copy(groups = Some(groups.fold(newValues)(_ ++ newValues)))
  /** if groups has a value, transforms to the result of function*/
  def mapGroups(f: Seq[String] => Seq[String]) : CertificateSigningRequestSpec = copy(groups = groups.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : CertificateSigningRequestSpec = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : CertificateSigningRequestSpec = copy(uid = uid.map(f))

  /** Returns a new data with extra set to new value */
  def withExtra(value: Map[String, Seq[String]]) : CertificateSigningRequestSpec = copy(extra = Some(value))
  /** Adds new values to extra */
  def addExtra(newValues: (String, Seq[String])*) : CertificateSigningRequestSpec = copy(extra = Some(extra.fold(newValues.toMap)(_ ++ newValues)))
  /** if extra has a value, transforms to the result of function*/
  def mapExtra(f: Map[String, Seq[String]] => Map[String, Seq[String]]) : CertificateSigningRequestSpec = copy(extra = extra.map(f))
}

