package io.k8s.api.batch.v1


/** PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check. */
final case class PodFailurePolicyOnExitCodesRequirement(
  operator : String,
  values : Seq[Int],
  containerName : Option[String] = None
) {

  /** Returns a new data with operator set to new value */
  def withOperator(value: String) : PodFailurePolicyOnExitCodesRequirement = copy(operator = value)
  /** transforms operator to result of function */
  def mapOperator(f: String => String) : PodFailurePolicyOnExitCodesRequirement = copy(operator = f(operator))

  /** Returns a new data with values set to new value */
  def withValues(value: Seq[Int]) : PodFailurePolicyOnExitCodesRequirement = copy(values = value)
  /** Appends new values to values */
  def addValues(newValues: Int*) : PodFailurePolicyOnExitCodesRequirement = copy(values = values ++ newValues)
  /** transforms values to result of function */
  def mapValues(f: Seq[Int] => Seq[Int]) : PodFailurePolicyOnExitCodesRequirement = copy(values = f(values))

  /** Returns a new data with containerName set to new value */
  def withContainerName(value: String) : PodFailurePolicyOnExitCodesRequirement = copy(containerName = Some(value))
  /** if containerName has a value, transforms to the result of function*/
  def mapContainerName(f: String => String) : PodFailurePolicyOnExitCodesRequirement = copy(containerName = containerName.map(f))
}

