package io.k8s.api.autoscaling.v2


/** MetricValueStatus holds the current value for a metric */
final case class MetricValueStatus(
  averageUtilization : Option[Int] = None,
  averageValue : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None,
  value : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None
) {

  /** Returns a new data with averageUtilization set to new value */
  def withAverageUtilization(value: Int) : MetricValueStatus = copy(averageUtilization = Some(value))
  /** if averageUtilization has a value, transforms to the result of function*/
  def mapAverageUtilization(f: Int => Int) : MetricValueStatus = copy(averageUtilization = averageUtilization.map(f))

  /** Returns a new data with averageValue set to new value */
  def withAverageValue(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricValueStatus = copy(averageValue = Some(value))
  /** if averageValue has a value, transforms to the result of function*/
  def mapAverageValue(f: io.k8s.apimachinery.pkg.api.resource.Quantity => io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricValueStatus = copy(averageValue = averageValue.map(f))

  /** Returns a new data with value set to new value */
  def withValue(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricValueStatus = copy(value = Some(value))
  /** if value has a value, transforms to the result of function*/
  def mapValue(f: io.k8s.apimachinery.pkg.api.resource.Quantity => io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricValueStatus = copy(value = value.map(f))
}

