package io.k8s.api.apps.v1


/** DeploymentStatus is the most recently observed status of the Deployment. */
final case class DeploymentStatus(
  conditions : Option[Seq[io.k8s.api.apps.v1.DeploymentCondition]] = None,
  collisionCount : Option[Int] = None,
  replicas : Option[Int] = None,
  availableReplicas : Option[Int] = None,
  unavailableReplicas : Option[Int] = None,
  observedGeneration : Option[Int] = None,
  updatedReplicas : Option[Int] = None,
  readyReplicas : Option[Int] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.apps.v1.DeploymentCondition]) : DeploymentStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.apps.v1.DeploymentCondition*) : DeploymentStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.apps.v1.DeploymentCondition] => Seq[io.k8s.api.apps.v1.DeploymentCondition]) : DeploymentStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with collisionCount set to new value */
  def withCollisionCount(value: Int) : DeploymentStatus = copy(collisionCount = Some(value))
  /** if collisionCount has a value, transforms to the result of function*/
  def mapCollisionCount(f: Int => Int) : DeploymentStatus = copy(collisionCount = collisionCount.map(f))

  /** Returns a new data with replicas set to new value */
  def withReplicas(value: Int) : DeploymentStatus = copy(replicas = Some(value))
  /** if replicas has a value, transforms to the result of function*/
  def mapReplicas(f: Int => Int) : DeploymentStatus = copy(replicas = replicas.map(f))

  /** Returns a new data with availableReplicas set to new value */
  def withAvailableReplicas(value: Int) : DeploymentStatus = copy(availableReplicas = Some(value))
  /** if availableReplicas has a value, transforms to the result of function*/
  def mapAvailableReplicas(f: Int => Int) : DeploymentStatus = copy(availableReplicas = availableReplicas.map(f))

  /** Returns a new data with unavailableReplicas set to new value */
  def withUnavailableReplicas(value: Int) : DeploymentStatus = copy(unavailableReplicas = Some(value))
  /** if unavailableReplicas has a value, transforms to the result of function*/
  def mapUnavailableReplicas(f: Int => Int) : DeploymentStatus = copy(unavailableReplicas = unavailableReplicas.map(f))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Int) : DeploymentStatus = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Int => Int) : DeploymentStatus = copy(observedGeneration = observedGeneration.map(f))

  /** Returns a new data with updatedReplicas set to new value */
  def withUpdatedReplicas(value: Int) : DeploymentStatus = copy(updatedReplicas = Some(value))
  /** if updatedReplicas has a value, transforms to the result of function*/
  def mapUpdatedReplicas(f: Int => Int) : DeploymentStatus = copy(updatedReplicas = updatedReplicas.map(f))

  /** Returns a new data with readyReplicas set to new value */
  def withReadyReplicas(value: Int) : DeploymentStatus = copy(readyReplicas = Some(value))
  /** if readyReplicas has a value, transforms to the result of function*/
  def mapReadyReplicas(f: Int => Int) : DeploymentStatus = copy(readyReplicas = readyReplicas.map(f))
}

