package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._

/** ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it. */
final case class ValidatingWebhookConfiguration(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  webhooks : Option[Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "ValidatingWebhookConfiguration", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingWebhookConfiguration = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ValidatingWebhookConfiguration = copy(metadata = metadata.map(f))

  /** Returns a new data with webhooks set to new value */
  def withWebhooks(value: Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]) : ValidatingWebhookConfiguration = copy(webhooks = Some(value))
  /** Appends new values to webhooks */
  def addWebhooks(newValues: io.k8s.api.admissionregistration.v1.ValidatingWebhook*) : ValidatingWebhookConfiguration = copy(webhooks = Some(webhooks.fold(newValues)(_ ++ newValues)))
  /** if webhooks has a value, transforms to the result of function*/
  def mapWebhooks(f: Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook] => Seq[io.k8s.api.admissionregistration.v1.ValidatingWebhook]) : ValidatingWebhookConfiguration = copy(webhooks = webhooks.map(f))
}

